namespace Microsoft.Samples.PlanMyNight.Web.Controllers.Tests
{
    using Microsoft.Samples.PlanMyNight.Entities;
    using Microsoft.Samples.PlanMyNight.Web.Controllers;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using Moq;
    using MvcContrib.TestHelper;

    [TestClass]
    public class SiteMasterControllerFixture
    {
        [TestMethod]
        public void ShouldReturnLogonPartialViewWithProfileData()
        {
            var builder = new TestControllerBuilder();
            var membershipService = new Mock<IMembershipService>();
            var expectedUserProfile = new UserProfile();
            membershipService.Setup(s => s.GetCurrentProfile()).Returns(expectedUserProfile);
            var controller = new SiteMasterController(membershipService.Object);
            builder.InitializeController(controller);

            var view = controller.LoginStatus();

            Assert.IsNotNull(view);
            Assert.AreSame("LogOn", view.ViewName);
            Assert.IsNotNull(view.ViewData.Model);
            Assert.AreSame(expectedUserProfile, view.ViewData.Model);
        }
    }
}
